package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait SSEStatus {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.SSEStatus
}
object SSEStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.SSEStatus
  ): zio.aws.dynamodb.model.SSEStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.SSEStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.SSEStatus.ENABLING =>
      val r = ENABLING
      r
    case software.amazon.awssdk.services.dynamodb.model.SSEStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.dynamodb.model.SSEStatus.DISABLING =>
      val r = DISABLING
      r
    case software.amazon.awssdk.services.dynamodb.model.SSEStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.dynamodb.model.SSEStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.SSEStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.SSEStatus =
      software.amazon.awssdk.services.dynamodb.model.SSEStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLING extends zio.aws.dynamodb.model.SSEStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.SSEStatus =
      software.amazon.awssdk.services.dynamodb.model.SSEStatus.ENABLING
  }
  case object ENABLED extends zio.aws.dynamodb.model.SSEStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.SSEStatus =
      software.amazon.awssdk.services.dynamodb.model.SSEStatus.ENABLED
  }
  case object DISABLING extends zio.aws.dynamodb.model.SSEStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.SSEStatus =
      software.amazon.awssdk.services.dynamodb.model.SSEStatus.DISABLING
  }
  case object DISABLED extends zio.aws.dynamodb.model.SSEStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.SSEStatus =
      software.amazon.awssdk.services.dynamodb.model.SSEStatus.DISABLED
  }
  case object UPDATING extends zio.aws.dynamodb.model.SSEStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.SSEStatus =
      software.amazon.awssdk.services.dynamodb.model.SSEStatus.UPDATING
  }
}
