package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBackupResponse(
    backupDescription: Optional[zio.aws.dynamodb.model.BackupDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse = {
    import DeleteBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse
      .builder()
      .optionallyWith(backupDescription.map(value => value.buildAwsValue()))(
        _.backupDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DeleteBackupResponse.ReadOnly =
    zio.aws.dynamodb.model.DeleteBackupResponse.wrap(buildAwsValue())
}
object DeleteBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteBackupResponse =
      zio.aws.dynamodb.model
        .DeleteBackupResponse(backupDescription.map(value => value.asEditable))
    def backupDescription
        : Optional[zio.aws.dynamodb.model.BackupDescription.ReadOnly]
    def getBackupDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.BackupDescription.ReadOnly
    ] = AwsError.unwrapOptionField("backupDescription", backupDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse
  ) extends zio.aws.dynamodb.model.DeleteBackupResponse.ReadOnly {
    override val backupDescription
        : Optional[zio.aws.dynamodb.model.BackupDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupDescription())
        .map(value => zio.aws.dynamodb.model.BackupDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse
  ): zio.aws.dynamodb.model.DeleteBackupResponse.ReadOnly = new Wrapper(impl)
}
