package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.AttributeName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutItemResponse(
    attributes: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
    ] = Optional.Absent,
    consumedCapacity: Optional[zio.aws.dynamodb.model.ConsumedCapacity] =
      Optional.Absent,
    itemCollectionMetrics: Optional[
      zio.aws.dynamodb.model.ItemCollectionMetrics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.PutItemResponse = {
    import PutItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.PutItemResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(consumedCapacity.map(value => value.buildAwsValue()))(
        _.consumedCapacity
      )
      .optionallyWith(
        itemCollectionMetrics.map(value => value.buildAwsValue())
      )(_.itemCollectionMetrics)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.PutItemResponse.ReadOnly =
    zio.aws.dynamodb.model.PutItemResponse.wrap(buildAwsValue())
}
object PutItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.PutItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.PutItemResponse =
      zio.aws.dynamodb.model.PutItemResponse(
        attributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        consumedCapacity.map(value => value.asEditable),
        itemCollectionMetrics.map(value => value.asEditable)
      )
    def attributes: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def consumedCapacity
        : Optional[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]
    def itemCollectionMetrics
        : Optional[zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly]
    def getAttributes: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] =
      AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
    def getItemCollectionMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly
    ] =
      AwsError.unwrapOptionField("itemCollectionMetrics", itemCollectionMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.PutItemResponse
  ) extends zio.aws.dynamodb.model.PutItemResponse.ReadOnly {
    override val attributes: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val consumedCapacity
        : Optional[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedCapacity())
        .map(value => zio.aws.dynamodb.model.ConsumedCapacity.wrap(value))
    override val itemCollectionMetrics
        : Optional[zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.itemCollectionMetrics())
        .map(value => zio.aws.dynamodb.model.ItemCollectionMetrics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.PutItemResponse
  ): zio.aws.dynamodb.model.PutItemResponse.ReadOnly = new Wrapper(impl)
}
