package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  CloudWatchLogGroupArn,
  LongObject,
  ImportStartTime,
  ProcessedItemCount,
  ImportEndTime,
  ImportedItemCount,
  ImportArn,
  TableArn,
  ClientToken,
  FailureCode,
  FailureMessage,
  ErrorCount,
  TableId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ImportTableDescription(
    importArn: Optional[ImportArn] = Optional.Absent,
    importStatus: Optional[zio.aws.dynamodb.model.ImportStatus] =
      Optional.Absent,
    tableArn: Optional[TableArn] = Optional.Absent,
    tableId: Optional[TableId] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    s3BucketSource: Optional[zio.aws.dynamodb.model.S3BucketSource] =
      Optional.Absent,
    errorCount: Optional[ErrorCount] = Optional.Absent,
    cloudWatchLogGroupArn: Optional[CloudWatchLogGroupArn] = Optional.Absent,
    inputFormat: Optional[zio.aws.dynamodb.model.InputFormat] = Optional.Absent,
    inputFormatOptions: Optional[zio.aws.dynamodb.model.InputFormatOptions] =
      Optional.Absent,
    inputCompressionType: Optional[
      zio.aws.dynamodb.model.InputCompressionType
    ] = Optional.Absent,
    tableCreationParameters: Optional[
      zio.aws.dynamodb.model.TableCreationParameters
    ] = Optional.Absent,
    startTime: Optional[ImportStartTime] = Optional.Absent,
    endTime: Optional[ImportEndTime] = Optional.Absent,
    processedSizeBytes: Optional[LongObject] = Optional.Absent,
    processedItemCount: Optional[ProcessedItemCount] = Optional.Absent,
    importedItemCount: Optional[ImportedItemCount] = Optional.Absent,
    failureCode: Optional[FailureCode] = Optional.Absent,
    failureMessage: Optional[FailureMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ImportTableDescription = {
    import ImportTableDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ImportTableDescription
      .builder()
      .optionallyWith(
        importArn.map(value => ImportArn.unwrap(value): java.lang.String)
      )(_.importArn)
      .optionallyWith(importStatus.map(value => value.unwrap))(_.importStatus)
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(
        tableId.map(value => TableId.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(s3BucketSource.map(value => value.buildAwsValue()))(
        _.s3BucketSource
      )
      .optionallyWith(
        errorCount.map(value => ErrorCount.unwrap(value): java.lang.Long)
      )(_.errorCount)
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          CloudWatchLogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(inputFormat.map(value => value.unwrap))(_.inputFormat)
      .optionallyWith(inputFormatOptions.map(value => value.buildAwsValue()))(
        _.inputFormatOptions
      )
      .optionallyWith(inputCompressionType.map(value => value.unwrap))(
        _.inputCompressionType
      )
      .optionallyWith(
        tableCreationParameters.map(value => value.buildAwsValue())
      )(_.tableCreationParameters)
      .optionallyWith(
        startTime.map(value => ImportStartTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => ImportEndTime.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(processedSizeBytes.map(value => value: java.lang.Long))(
        _.processedSizeBytes
      )
      .optionallyWith(
        processedItemCount.map(value =>
          ProcessedItemCount.unwrap(value): java.lang.Long
        )
      )(_.processedItemCount)
      .optionallyWith(
        importedItemCount.map(value =>
          ImportedItemCount.unwrap(value): java.lang.Long
        )
      )(_.importedItemCount)
      .optionallyWith(
        failureCode.map(value => FailureCode.unwrap(value): java.lang.String)
      )(_.failureCode)
      .optionallyWith(
        failureMessage.map(value =>
          FailureMessage.unwrap(value): java.lang.String
        )
      )(_.failureMessage)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ImportTableDescription.ReadOnly =
    zio.aws.dynamodb.model.ImportTableDescription.wrap(buildAwsValue())
}
object ImportTableDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ImportTableDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ImportTableDescription =
      zio.aws.dynamodb.model.ImportTableDescription(
        importArn.map(value => value),
        importStatus.map(value => value),
        tableArn.map(value => value),
        tableId.map(value => value),
        clientToken.map(value => value),
        s3BucketSource.map(value => value.asEditable),
        errorCount.map(value => value),
        cloudWatchLogGroupArn.map(value => value),
        inputFormat.map(value => value),
        inputFormatOptions.map(value => value.asEditable),
        inputCompressionType.map(value => value),
        tableCreationParameters.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        processedSizeBytes.map(value => value),
        processedItemCount.map(value => value),
        importedItemCount.map(value => value),
        failureCode.map(value => value),
        failureMessage.map(value => value)
      )
    def importArn: Optional[ImportArn]
    def importStatus: Optional[zio.aws.dynamodb.model.ImportStatus]
    def tableArn: Optional[TableArn]
    def tableId: Optional[TableId]
    def clientToken: Optional[ClientToken]
    def s3BucketSource: Optional[zio.aws.dynamodb.model.S3BucketSource.ReadOnly]
    def errorCount: Optional[ErrorCount]
    def cloudWatchLogGroupArn: Optional[CloudWatchLogGroupArn]
    def inputFormat: Optional[zio.aws.dynamodb.model.InputFormat]
    def inputFormatOptions
        : Optional[zio.aws.dynamodb.model.InputFormatOptions.ReadOnly]
    def inputCompressionType
        : Optional[zio.aws.dynamodb.model.InputCompressionType]
    def tableCreationParameters
        : Optional[zio.aws.dynamodb.model.TableCreationParameters.ReadOnly]
    def startTime: Optional[ImportStartTime]
    def endTime: Optional[ImportEndTime]
    def processedSizeBytes: Optional[LongObject]
    def processedItemCount: Optional[ProcessedItemCount]
    def importedItemCount: Optional[ImportedItemCount]
    def failureCode: Optional[FailureCode]
    def failureMessage: Optional[FailureMessage]
    def getImportArn: ZIO[Any, AwsError, ImportArn] =
      AwsError.unwrapOptionField("importArn", importArn)
    def getImportStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ImportStatus] =
      AwsError.unwrapOptionField("importStatus", importStatus)
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getTableId: ZIO[Any, AwsError, TableId] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getS3BucketSource
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.S3BucketSource.ReadOnly] =
      AwsError.unwrapOptionField("s3BucketSource", s3BucketSource)
    def getErrorCount: ZIO[Any, AwsError, ErrorCount] =
      AwsError.unwrapOptionField("errorCount", errorCount)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, CloudWatchLogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getInputFormat: ZIO[Any, AwsError, zio.aws.dynamodb.model.InputFormat] =
      AwsError.unwrapOptionField("inputFormat", inputFormat)
    def getInputFormatOptions: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.InputFormatOptions.ReadOnly
    ] = AwsError.unwrapOptionField("inputFormatOptions", inputFormatOptions)
    def getInputCompressionType
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.InputCompressionType] =
      AwsError.unwrapOptionField("inputCompressionType", inputCompressionType)
    def getTableCreationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TableCreationParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tableCreationParameters",
      tableCreationParameters
    )
    def getStartTime: ZIO[Any, AwsError, ImportStartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, ImportEndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getProcessedSizeBytes: ZIO[Any, AwsError, LongObject] =
      AwsError.unwrapOptionField("processedSizeBytes", processedSizeBytes)
    def getProcessedItemCount: ZIO[Any, AwsError, ProcessedItemCount] =
      AwsError.unwrapOptionField("processedItemCount", processedItemCount)
    def getImportedItemCount: ZIO[Any, AwsError, ImportedItemCount] =
      AwsError.unwrapOptionField("importedItemCount", importedItemCount)
    def getFailureCode: ZIO[Any, AwsError, FailureCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, FailureMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ImportTableDescription
  ) extends zio.aws.dynamodb.model.ImportTableDescription.ReadOnly {
    override val importArn: Optional[ImportArn] = zio.aws.core.internal
      .optionalFromNullable(impl.importArn())
      .map(value => zio.aws.dynamodb.model.primitives.ImportArn(value))
    override val importStatus: Optional[zio.aws.dynamodb.model.ImportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importStatus())
        .map(value => zio.aws.dynamodb.model.ImportStatus.wrap(value))
    override val tableArn: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val tableId: Optional[TableId] = zio.aws.core.internal
      .optionalFromNullable(impl.tableId())
      .map(value => zio.aws.dynamodb.model.primitives.TableId(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.dynamodb.model.primitives.ClientToken(value))
    override val s3BucketSource
        : Optional[zio.aws.dynamodb.model.S3BucketSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BucketSource())
        .map(value => zio.aws.dynamodb.model.S3BucketSource.wrap(value))
    override val errorCount: Optional[ErrorCount] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCount())
      .map(value => zio.aws.dynamodb.model.primitives.ErrorCount(value))
    override val cloudWatchLogGroupArn: Optional[CloudWatchLogGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupArn())
        .map(value =>
          zio.aws.dynamodb.model.primitives.CloudWatchLogGroupArn(value)
        )
    override val inputFormat: Optional[zio.aws.dynamodb.model.InputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFormat())
        .map(value => zio.aws.dynamodb.model.InputFormat.wrap(value))
    override val inputFormatOptions
        : Optional[zio.aws.dynamodb.model.InputFormatOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFormatOptions())
        .map(value => zio.aws.dynamodb.model.InputFormatOptions.wrap(value))
    override val inputCompressionType
        : Optional[zio.aws.dynamodb.model.InputCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputCompressionType())
        .map(value => zio.aws.dynamodb.model.InputCompressionType.wrap(value))
    override val tableCreationParameters
        : Optional[zio.aws.dynamodb.model.TableCreationParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableCreationParameters())
        .map(value =>
          zio.aws.dynamodb.model.TableCreationParameters.wrap(value)
        )
    override val startTime: Optional[ImportStartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.dynamodb.model.primitives.ImportStartTime(value))
    override val endTime: Optional[ImportEndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.dynamodb.model.primitives.ImportEndTime(value))
    override val processedSizeBytes: Optional[LongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processedSizeBytes())
        .map(value => value: LongObject)
    override val processedItemCount: Optional[ProcessedItemCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processedItemCount())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ProcessedItemCount(value)
        )
    override val importedItemCount: Optional[ImportedItemCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedItemCount())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ImportedItemCount(value)
        )
    override val failureCode: Optional[FailureCode] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => zio.aws.dynamodb.model.primitives.FailureCode(value))
    override val failureMessage: Optional[FailureMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureMessage())
        .map(value => zio.aws.dynamodb.model.primitives.FailureMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ImportTableDescription
  ): zio.aws.dynamodb.model.ImportTableDescription.ReadOnly = new Wrapper(impl)
}
