package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTableResponse(
    tableDescription: Optional[zio.aws.dynamodb.model.TableDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse = {
    import DeleteTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse
      .builder()
      .optionallyWith(tableDescription.map(value => value.buildAwsValue()))(
        _.tableDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DeleteTableResponse.ReadOnly =
    zio.aws.dynamodb.model.DeleteTableResponse.wrap(buildAwsValue())
}
object DeleteTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteTableResponse =
      zio.aws.dynamodb.model
        .DeleteTableResponse(tableDescription.map(value => value.asEditable))
    def tableDescription
        : Optional[zio.aws.dynamodb.model.TableDescription.ReadOnly]
    def getTableDescription
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      AwsError.unwrapOptionField("tableDescription", tableDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse
  ) extends zio.aws.dynamodb.model.DeleteTableResponse.ReadOnly {
    override val tableDescription
        : Optional[zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableDescription())
        .map(value => zio.aws.dynamodb.model.TableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse
  ): zio.aws.dynamodb.model.DeleteTableResponse.ReadOnly = new Wrapper(impl)
}
