package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTablesResponse(
    tableNames: Optional[Iterable[TableName]] = Optional.Absent,
    lastEvaluatedTableName: Optional[TableName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListTablesResponse = {
    import ListTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListTablesResponse
      .builder()
      .optionallyWith(
        tableNames.map(value =>
          value.map { item =>
            TableName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tableNames)
      .optionallyWith(
        lastEvaluatedTableName.map(value =>
          TableName.unwrap(value): java.lang.String
        )
      )(_.lastEvaluatedTableName)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListTablesResponse.ReadOnly =
    zio.aws.dynamodb.model.ListTablesResponse.wrap(buildAwsValue())
}
object ListTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListTablesResponse =
      zio.aws.dynamodb.model.ListTablesResponse(
        tableNames.map(value => value),
        lastEvaluatedTableName.map(value => value)
      )
    def tableNames: Optional[List[TableName]]
    def lastEvaluatedTableName: Optional[TableName]
    def getTableNames: ZIO[Any, AwsError, List[TableName]] =
      AwsError.unwrapOptionField("tableNames", tableNames)
    def getLastEvaluatedTableName: ZIO[Any, AwsError, TableName] = AwsError
      .unwrapOptionField("lastEvaluatedTableName", lastEvaluatedTableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTablesResponse
  ) extends zio.aws.dynamodb.model.ListTablesResponse.ReadOnly {
    override val tableNames: Optional[List[TableName]] = zio.aws.core.internal
      .optionalFromNullable(impl.tableNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.TableName(item)
        }.toList
      )
    override val lastEvaluatedTableName: Optional[TableName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastEvaluatedTableName())
        .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTablesResponse
  ): zio.aws.dynamodb.model.ListTablesResponse.ReadOnly = new Wrapper(impl)
}
