package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.KeySchemaAttributeName
import scala.jdk.CollectionConverters._
final case class KeySchemaElement(
    attributeName: KeySchemaAttributeName,
    keyType: zio.aws.dynamodb.model.KeyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.KeySchemaElement = {
    import KeySchemaElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.KeySchemaElement
      .builder()
      .attributeName(
        KeySchemaAttributeName.unwrap(attributeName): java.lang.String
      )
      .keyType(keyType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.KeySchemaElement.ReadOnly =
    zio.aws.dynamodb.model.KeySchemaElement.wrap(buildAwsValue())
}
object KeySchemaElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.KeySchemaElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.KeySchemaElement =
      zio.aws.dynamodb.model.KeySchemaElement(attributeName, keyType)
    def attributeName: KeySchemaAttributeName
    def keyType: zio.aws.dynamodb.model.KeyType
    def getAttributeName: ZIO[Any, Nothing, KeySchemaAttributeName] =
      ZIO.succeed(attributeName)
    def getKeyType: ZIO[Any, Nothing, zio.aws.dynamodb.model.KeyType] =
      ZIO.succeed(keyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.KeySchemaElement
  ) extends zio.aws.dynamodb.model.KeySchemaElement.ReadOnly {
    override val attributeName: KeySchemaAttributeName =
      zio.aws.dynamodb.model.primitives
        .KeySchemaAttributeName(impl.attributeName())
    override val keyType: zio.aws.dynamodb.model.KeyType =
      zio.aws.dynamodb.model.KeyType.wrap(impl.keyType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.KeySchemaElement
  ): zio.aws.dynamodb.model.KeySchemaElement.ReadOnly = new Wrapper(impl)
}
