package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  CloudWatchLogGroupArn,
  ImportStartTime,
  ImportEndTime,
  ImportArn,
  TableArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ImportSummary(
    importArn: Optional[ImportArn] = Optional.Absent,
    importStatus: Optional[zio.aws.dynamodb.model.ImportStatus] =
      Optional.Absent,
    tableArn: Optional[TableArn] = Optional.Absent,
    s3BucketSource: Optional[zio.aws.dynamodb.model.S3BucketSource] =
      Optional.Absent,
    cloudWatchLogGroupArn: Optional[CloudWatchLogGroupArn] = Optional.Absent,
    inputFormat: Optional[zio.aws.dynamodb.model.InputFormat] = Optional.Absent,
    startTime: Optional[ImportStartTime] = Optional.Absent,
    endTime: Optional[ImportEndTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ImportSummary = {
    import ImportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ImportSummary
      .builder()
      .optionallyWith(
        importArn.map(value => ImportArn.unwrap(value): java.lang.String)
      )(_.importArn)
      .optionallyWith(importStatus.map(value => value.unwrap))(_.importStatus)
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(s3BucketSource.map(value => value.buildAwsValue()))(
        _.s3BucketSource
      )
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          CloudWatchLogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(inputFormat.map(value => value.unwrap))(_.inputFormat)
      .optionallyWith(
        startTime.map(value => ImportStartTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => ImportEndTime.unwrap(value): Instant)
      )(_.endTime)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ImportSummary.ReadOnly =
    zio.aws.dynamodb.model.ImportSummary.wrap(buildAwsValue())
}
object ImportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ImportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ImportSummary =
      zio.aws.dynamodb.model.ImportSummary(
        importArn.map(value => value),
        importStatus.map(value => value),
        tableArn.map(value => value),
        s3BucketSource.map(value => value.asEditable),
        cloudWatchLogGroupArn.map(value => value),
        inputFormat.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def importArn: Optional[ImportArn]
    def importStatus: Optional[zio.aws.dynamodb.model.ImportStatus]
    def tableArn: Optional[TableArn]
    def s3BucketSource: Optional[zio.aws.dynamodb.model.S3BucketSource.ReadOnly]
    def cloudWatchLogGroupArn: Optional[CloudWatchLogGroupArn]
    def inputFormat: Optional[zio.aws.dynamodb.model.InputFormat]
    def startTime: Optional[ImportStartTime]
    def endTime: Optional[ImportEndTime]
    def getImportArn: ZIO[Any, AwsError, ImportArn] =
      AwsError.unwrapOptionField("importArn", importArn)
    def getImportStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ImportStatus] =
      AwsError.unwrapOptionField("importStatus", importStatus)
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getS3BucketSource
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.S3BucketSource.ReadOnly] =
      AwsError.unwrapOptionField("s3BucketSource", s3BucketSource)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, CloudWatchLogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getInputFormat: ZIO[Any, AwsError, zio.aws.dynamodb.model.InputFormat] =
      AwsError.unwrapOptionField("inputFormat", inputFormat)
    def getStartTime: ZIO[Any, AwsError, ImportStartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, ImportEndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ImportSummary
  ) extends zio.aws.dynamodb.model.ImportSummary.ReadOnly {
    override val importArn: Optional[ImportArn] = zio.aws.core.internal
      .optionalFromNullable(impl.importArn())
      .map(value => zio.aws.dynamodb.model.primitives.ImportArn(value))
    override val importStatus: Optional[zio.aws.dynamodb.model.ImportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importStatus())
        .map(value => zio.aws.dynamodb.model.ImportStatus.wrap(value))
    override val tableArn: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val s3BucketSource
        : Optional[zio.aws.dynamodb.model.S3BucketSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3BucketSource())
        .map(value => zio.aws.dynamodb.model.S3BucketSource.wrap(value))
    override val cloudWatchLogGroupArn: Optional[CloudWatchLogGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupArn())
        .map(value =>
          zio.aws.dynamodb.model.primitives.CloudWatchLogGroupArn(value)
        )
    override val inputFormat: Optional[zio.aws.dynamodb.model.InputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputFormat())
        .map(value => zio.aws.dynamodb.model.InputFormat.wrap(value))
    override val startTime: Optional[ImportStartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.dynamodb.model.primitives.ImportStartTime(value))
    override val endTime: Optional[ImportEndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.dynamodb.model.primitives.ImportEndTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ImportSummary
  ): zio.aws.dynamodb.model.ImportSummary.ReadOnly = new Wrapper(impl)
}
