package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.ExportArn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportSummary(
    exportArn: Optional[ExportArn] = Optional.Absent,
    exportStatus: Optional[zio.aws.dynamodb.model.ExportStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExportSummary = {
    import ExportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExportSummary
      .builder()
      .optionallyWith(
        exportArn.map(value => ExportArn.unwrap(value): java.lang.String)
      )(_.exportArn)
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExportSummary.ReadOnly =
    zio.aws.dynamodb.model.ExportSummary.wrap(buildAwsValue())
}
object ExportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExportSummary =
      zio.aws.dynamodb.model.ExportSummary(
        exportArn.map(value => value),
        exportStatus.map(value => value)
      )
    def exportArn: Optional[ExportArn]
    def exportStatus: Optional[zio.aws.dynamodb.model.ExportStatus]
    def getExportArn: ZIO[Any, AwsError, ExportArn] =
      AwsError.unwrapOptionField("exportArn", exportArn)
    def getExportStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportStatus] =
      AwsError.unwrapOptionField("exportStatus", exportStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportSummary
  ) extends zio.aws.dynamodb.model.ExportSummary.ReadOnly {
    override val exportArn: Optional[ExportArn] = zio.aws.core.internal
      .optionalFromNullable(impl.exportArn())
      .map(value => zio.aws.dynamodb.model.primitives.ExportArn(value))
    override val exportStatus: Optional[zio.aws.dynamodb.model.ExportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportStatus())
        .map(value => zio.aws.dynamodb.model.ExportStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportSummary
  ): zio.aws.dynamodb.model.ExportSummary.ReadOnly = new Wrapper(impl)
}
