package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{BooleanObject, PositiveLongObject}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingSettingsDescription(
    minimumUnits: Optional[PositiveLongObject] = Optional.Absent,
    maximumUnits: Optional[PositiveLongObject] = Optional.Absent,
    autoScalingDisabled: Optional[BooleanObject] = Optional.Absent,
    autoScalingRoleArn: Optional[String] = Optional.Absent,
    scalingPolicies: Optional[
      Iterable[zio.aws.dynamodb.model.AutoScalingPolicyDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription = {
    import AutoScalingSettingsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription
      .builder()
      .optionallyWith(
        minimumUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.minimumUnits)
      .optionallyWith(
        maximumUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.maximumUnits)
      .optionallyWith(
        autoScalingDisabled.map(value => value: java.lang.Boolean)
      )(_.autoScalingDisabled)
      .optionallyWith(autoScalingRoleArn.map(value => value: java.lang.String))(
        _.autoScalingRoleArn
      )
      .optionallyWith(
        scalingPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingPolicies)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly =
    zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(buildAwsValue())
}
object AutoScalingSettingsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.AutoScalingSettingsDescription =
      zio.aws.dynamodb.model.AutoScalingSettingsDescription(
        minimumUnits.map(value => value),
        maximumUnits.map(value => value),
        autoScalingDisabled.map(value => value),
        autoScalingRoleArn.map(value => value),
        scalingPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def minimumUnits: Optional[PositiveLongObject]
    def maximumUnits: Optional[PositiveLongObject]
    def autoScalingDisabled: Optional[BooleanObject]
    def autoScalingRoleArn: Optional[String]
    def scalingPolicies: Optional[
      List[zio.aws.dynamodb.model.AutoScalingPolicyDescription.ReadOnly]
    ]
    def getMinimumUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("minimumUnits", minimumUnits)
    def getMaximumUnits: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("maximumUnits", maximumUnits)
    def getAutoScalingDisabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("autoScalingDisabled", autoScalingDisabled)
    def getAutoScalingRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("autoScalingRoleArn", autoScalingRoleArn)
    def getScalingPolicies: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AutoScalingPolicyDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingPolicies", scalingPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription
  ) extends zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly {
    override val minimumUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val maximumUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val autoScalingDisabled: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingDisabled())
        .map(value => value: BooleanObject)
    override val autoScalingRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingRoleArn())
      .map(value => value: String)
    override val scalingPolicies: Optional[
      List[zio.aws.dynamodb.model.AutoScalingPolicyDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scalingPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.AutoScalingPolicyDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsDescription
  ): zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly =
    new Wrapper(impl)
}
