package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait ConditionalOperator {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ConditionalOperator
}
object ConditionalOperator {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ConditionalOperator
  ): zio.aws.dynamodb.model.ConditionalOperator = value match {
    case software.amazon.awssdk.services.dynamodb.model.ConditionalOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ConditionalOperator.AND =>
      val r = AND
      r
    case software.amazon.awssdk.services.dynamodb.model.ConditionalOperator.OR =>
      val r = OR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.ConditionalOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ConditionalOperator =
      software.amazon.awssdk.services.dynamodb.model.ConditionalOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object AND extends zio.aws.dynamodb.model.ConditionalOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ConditionalOperator =
      software.amazon.awssdk.services.dynamodb.model.ConditionalOperator.AND
  }
  case object OR extends zio.aws.dynamodb.model.ConditionalOperator {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ConditionalOperator =
      software.amazon.awssdk.services.dynamodb.model.ConditionalOperator.OR
  }
}
