package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchExecuteStatementRequest(
    statements: Iterable[zio.aws.dynamodb.model.BatchStatementRequest],
    returnConsumedCapacity: Optional[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest = {
    import BatchExecuteStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest
      .builder()
      .statements(statements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BatchExecuteStatementRequest.ReadOnly =
    zio.aws.dynamodb.model.BatchExecuteStatementRequest.wrap(buildAwsValue())
}
object BatchExecuteStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchExecuteStatementRequest =
      zio.aws.dynamodb.model.BatchExecuteStatementRequest(
        statements.map { item =>
          item.asEditable
        },
        returnConsumedCapacity.map(value => value)
      )
    def statements: List[zio.aws.dynamodb.model.BatchStatementRequest.ReadOnly]
    def returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def getStatements: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.BatchStatementRequest.ReadOnly
    ]] = ZIO.succeed(statements)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest
  ) extends zio.aws.dynamodb.model.BatchExecuteStatementRequest.ReadOnly {
    override val statements
        : List[zio.aws.dynamodb.model.BatchStatementRequest.ReadOnly] = impl
      .statements()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.BatchStatementRequest.wrap(item)
      }
      .toList
    override val returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnConsumedCapacity())
        .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest
  ): zio.aws.dynamodb.model.BatchExecuteStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
