package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateTableResponse(
    tableDescription: Optional[zio.aws.dynamodb.model.TableDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse = {
    import UpdateTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse
      .builder()
      .optionallyWith(tableDescription.map(value => value.buildAwsValue()))(
        _.tableDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.UpdateTableResponse.ReadOnly =
    zio.aws.dynamodb.model.UpdateTableResponse.wrap(buildAwsValue())
}
object UpdateTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateTableResponse =
      zio.aws.dynamodb.model
        .UpdateTableResponse(tableDescription.map(value => value.asEditable))
    def tableDescription
        : Optional[zio.aws.dynamodb.model.TableDescription.ReadOnly]
    def getTableDescription
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      AwsError.unwrapOptionField("tableDescription", tableDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse
  ) extends zio.aws.dynamodb.model.UpdateTableResponse.ReadOnly {
    override val tableDescription
        : Optional[zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableDescription())
        .map(value => zio.aws.dynamodb.model.TableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse
  ): zio.aws.dynamodb.model.UpdateTableResponse.ReadOnly = new Wrapper(impl)
}
