package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TableClassSummary(
    tableClass: Optional[zio.aws.dynamodb.model.TableClass] = Optional.Absent,
    lastUpdateDateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TableClassSummary = {
    import TableClassSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TableClassSummary
      .builder()
      .optionallyWith(tableClass.map(value => value.unwrap))(_.tableClass)
      .optionallyWith(
        lastUpdateDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdateDateTime)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TableClassSummary.ReadOnly =
    zio.aws.dynamodb.model.TableClassSummary.wrap(buildAwsValue())
}
object TableClassSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TableClassSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TableClassSummary =
      zio.aws.dynamodb.model.TableClassSummary(
        tableClass.map(value => value),
        lastUpdateDateTime.map(value => value)
      )
    def tableClass: Optional[zio.aws.dynamodb.model.TableClass]
    def lastUpdateDateTime: Optional[Date]
    def getTableClass: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableClass] =
      AwsError.unwrapOptionField("tableClass", tableClass)
    def getLastUpdateDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdateDateTime", lastUpdateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TableClassSummary
  ) extends zio.aws.dynamodb.model.TableClassSummary.ReadOnly {
    override val tableClass: Optional[zio.aws.dynamodb.model.TableClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableClass())
        .map(value => zio.aws.dynamodb.model.TableClass.wrap(value))
    override val lastUpdateDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TableClassSummary
  ): zio.aws.dynamodb.model.TableClassSummary.ReadOnly = new Wrapper(impl)
}
