package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.{BackupName, TableName}
import scala.jdk.CollectionConverters._
final case class CreateBackupRequest(
    tableName: TableName,
    backupName: BackupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest = {
    import CreateBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .backupName(BackupName.unwrap(backupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CreateBackupRequest.ReadOnly =
    zio.aws.dynamodb.model.CreateBackupRequest.wrap(buildAwsValue())
}
object CreateBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateBackupRequest =
      zio.aws.dynamodb.model.CreateBackupRequest(tableName, backupName)
    def tableName: TableName
    def backupName: BackupName
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getBackupName: ZIO[Any, Nothing, BackupName] = ZIO.succeed(backupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest
  ) extends zio.aws.dynamodb.model.CreateBackupRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val backupName: BackupName =
      zio.aws.dynamodb.model.primitives.BackupName(impl.backupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest
  ): zio.aws.dynamodb.model.CreateBackupRequest.ReadOnly = new Wrapper(impl)
}
