package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait ContinuousBackupsStatus {
  def unwrap
      : software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus
}
object ContinuousBackupsStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus
  ): zio.aws.dynamodb.model.ContinuousBackupsStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.ContinuousBackupsStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus =
      software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.dynamodb.model.ContinuousBackupsStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus =
      software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus.ENABLED
  }
  case object DISABLED extends zio.aws.dynamodb.model.ContinuousBackupsStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus =
      software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus.DISABLED
  }
}
