package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  Date,
  BooleanObject,
  TableName,
  TableArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RestoreTableToPointInTimeRequest(
    sourceTableArn: Optional[TableArn] = Optional.Absent,
    sourceTableName: Optional[TableName] = Optional.Absent,
    targetTableName: TableName,
    useLatestRestorableTime: Optional[BooleanObject] = Optional.Absent,
    restoreDateTime: Optional[Date] = Optional.Absent,
    billingModeOverride: Optional[zio.aws.dynamodb.model.BillingMode] =
      Optional.Absent,
    globalSecondaryIndexOverride: Optional[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndex]
    ] = Optional.Absent,
    localSecondaryIndexOverride: Optional[
      Iterable[zio.aws.dynamodb.model.LocalSecondaryIndex]
    ] = Optional.Absent,
    provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = Optional.Absent,
    sseSpecificationOverride: Optional[
      zio.aws.dynamodb.model.SSESpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest = {
    import RestoreTableToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest
      .builder()
      .optionallyWith(
        sourceTableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.sourceTableArn)
      .optionallyWith(
        sourceTableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.sourceTableName)
      .targetTableName(TableName.unwrap(targetTableName): java.lang.String)
      .optionallyWith(
        useLatestRestorableTime.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableTime)
      .optionallyWith(
        restoreDateTime.map(value => Date.unwrap(value): Instant)
      )(_.restoreDateTime)
      .optionallyWith(billingModeOverride.map(value => value.unwrap))(
        _.billingModeOverride
      )
      .optionallyWith(
        globalSecondaryIndexOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexOverride)
      .optionallyWith(
        localSecondaryIndexOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localSecondaryIndexOverride)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        sseSpecificationOverride.map(value => value.buildAwsValue())
      )(_.sseSpecificationOverride)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.RestoreTableToPointInTimeRequest.ReadOnly =
    zio.aws.dynamodb.model.RestoreTableToPointInTimeRequest
      .wrap(buildAwsValue())
}
object RestoreTableToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.RestoreTableToPointInTimeRequest =
      zio.aws.dynamodb.model.RestoreTableToPointInTimeRequest(
        sourceTableArn.map(value => value),
        sourceTableName.map(value => value),
        targetTableName,
        useLatestRestorableTime.map(value => value),
        restoreDateTime.map(value => value),
        billingModeOverride.map(value => value),
        globalSecondaryIndexOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        localSecondaryIndexOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisionedThroughputOverride.map(value => value.asEditable),
        sseSpecificationOverride.map(value => value.asEditable)
      )
    def sourceTableArn: Optional[TableArn]
    def sourceTableName: Optional[TableName]
    def targetTableName: TableName
    def useLatestRestorableTime: Optional[BooleanObject]
    def restoreDateTime: Optional[Date]
    def billingModeOverride: Optional[zio.aws.dynamodb.model.BillingMode]
    def globalSecondaryIndexOverride
        : Optional[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]]
    def localSecondaryIndexOverride
        : Optional[List[zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly]]
    def provisionedThroughputOverride
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def sseSpecificationOverride
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly]
    def getSourceTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("sourceTableArn", sourceTableArn)
    def getSourceTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("sourceTableName", sourceTableName)
    def getTargetTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(targetTableName)
    def getUseLatestRestorableTime: ZIO[Any, AwsError, BooleanObject] = AwsError
      .unwrapOptionField("useLatestRestorableTime", useLatestRestorableTime)
    def getRestoreDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("restoreDateTime", restoreDateTime)
    def getBillingModeOverride
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] =
      AwsError.unwrapOptionField("billingModeOverride", billingModeOverride)
    def getGlobalSecondaryIndexOverride: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexOverride",
      globalSecondaryIndexOverride
    )
    def getLocalSecondaryIndexOverride: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "localSecondaryIndexOverride",
      localSecondaryIndexOverride
    )
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getSseSpecificationOverride
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      AwsError.unwrapOptionField(
        "sseSpecificationOverride",
        sseSpecificationOverride
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest
  ) extends zio.aws.dynamodb.model.RestoreTableToPointInTimeRequest.ReadOnly {
    override val sourceTableArn: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceTableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val sourceTableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceTableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val targetTableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.targetTableName())
    override val useLatestRestorableTime: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useLatestRestorableTime())
        .map(value => value: BooleanObject)
    override val restoreDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val billingModeOverride
        : Optional[zio.aws.dynamodb.model.BillingMode] = zio.aws.core.internal
      .optionalFromNullable(impl.billingModeOverride())
      .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val globalSecondaryIndexOverride
        : Optional[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalSecondaryIndexOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.GlobalSecondaryIndex.wrap(item)
          }.toList
        )
    override val localSecondaryIndexOverride
        : Optional[List[zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localSecondaryIndexOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.LocalSecondaryIndex.wrap(item)
          }.toList
        )
    override val provisionedThroughputOverride
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughputOverride())
        .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
    override val sseSpecificationOverride
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseSpecificationOverride())
        .map(value => zio.aws.dynamodb.model.SSESpecification.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest
  ): zio.aws.dynamodb.model.RestoreTableToPointInTimeRequest.ReadOnly =
    new Wrapper(impl)
}
