package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputFormatOptions(
    csv: Optional[zio.aws.dynamodb.model.CsvOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.InputFormatOptions = {
    import InputFormatOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.InputFormatOptions
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.InputFormatOptions.ReadOnly =
    zio.aws.dynamodb.model.InputFormatOptions.wrap(buildAwsValue())
}
object InputFormatOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.InputFormatOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.InputFormatOptions =
      zio.aws.dynamodb.model
        .InputFormatOptions(csv.map(value => value.asEditable))
    def csv: Optional[zio.aws.dynamodb.model.CsvOptions.ReadOnly]
    def getCsv: ZIO[Any, AwsError, zio.aws.dynamodb.model.CsvOptions.ReadOnly] =
      AwsError.unwrapOptionField("csv", csv)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.InputFormatOptions
  ) extends zio.aws.dynamodb.model.InputFormatOptions.ReadOnly {
    override val csv: Optional[zio.aws.dynamodb.model.CsvOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.csv())
        .map(value => zio.aws.dynamodb.model.CsvOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.InputFormatOptions
  ): zio.aws.dynamodb.model.InputFormatOptions.ReadOnly = new Wrapper(impl)
}
