package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.ExportArn
import scala.jdk.CollectionConverters._
final case class DescribeExportRequest(exportArn: ExportArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest = {
    import DescribeExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest
      .builder()
      .exportArn(ExportArn.unwrap(exportArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeExportRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeExportRequest.wrap(buildAwsValue())
}
object DescribeExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeExportRequest =
      zio.aws.dynamodb.model.DescribeExportRequest(exportArn)
    def exportArn: ExportArn
    def getExportArn: ZIO[Any, Nothing, ExportArn] = ZIO.succeed(exportArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest
  ) extends zio.aws.dynamodb.model.DescribeExportRequest.ReadOnly {
    override val exportArn: ExportArn =
      zio.aws.dynamodb.model.primitives.ExportArn(impl.exportArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest
  ): zio.aws.dynamodb.model.DescribeExportRequest.ReadOnly = new Wrapper(impl)
}
