package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait ScalarAttributeType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType
}
object ScalarAttributeType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType
  ): zio.aws.dynamodb.model.ScalarAttributeType = value match {
    case software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType.S =>
      val r = S
      r
    case software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType.N =>
      val r = N
      r
    case software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType.B =>
      val r = B
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.ScalarAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType =
      software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType.UNKNOWN_TO_SDK_VERSION
  }
  case object S extends zio.aws.dynamodb.model.ScalarAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType =
      software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType.S
  }
  case object N extends zio.aws.dynamodb.model.ScalarAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType =
      software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType.N
  }
  case object B extends zio.aws.dynamodb.model.ScalarAttributeType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType =
      software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType.B
  }
}
