package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{NextTokenString, ResourceArnString}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTagsOfResourceRequest(
    resourceArn: ResourceArnString,
    nextToken: Optional[NextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest = {
    import ListTagsOfResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListTagsOfResourceRequest.ReadOnly =
    zio.aws.dynamodb.model.ListTagsOfResourceRequest.wrap(buildAwsValue())
}
object ListTagsOfResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListTagsOfResourceRequest =
      zio.aws.dynamodb.model
        .ListTagsOfResourceRequest(resourceArn, nextToken.map(value => value))
    def resourceArn: ResourceArnString
    def nextToken: Optional[NextTokenString]
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest
  ) extends zio.aws.dynamodb.model.ListTagsOfResourceRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.dynamodb.model.primitives.ResourceArnString(impl.resourceArn())
    override val nextToken: Optional[NextTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.NextTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest
  ): zio.aws.dynamodb.model.ListTagsOfResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
