package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TimeToLiveAttributeName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TimeToLiveDescription(
    timeToLiveStatus: Optional[zio.aws.dynamodb.model.TimeToLiveStatus] =
      Optional.Absent,
    attributeName: Optional[TimeToLiveAttributeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TimeToLiveDescription = {
    import TimeToLiveDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TimeToLiveDescription
      .builder()
      .optionallyWith(timeToLiveStatus.map(value => value.unwrap))(
        _.timeToLiveStatus
      )
      .optionallyWith(
        attributeName.map(value =>
          TimeToLiveAttributeName.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TimeToLiveDescription.ReadOnly =
    zio.aws.dynamodb.model.TimeToLiveDescription.wrap(buildAwsValue())
}
object TimeToLiveDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TimeToLiveDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TimeToLiveDescription =
      zio.aws.dynamodb.model.TimeToLiveDescription(
        timeToLiveStatus.map(value => value),
        attributeName.map(value => value)
      )
    def timeToLiveStatus: Optional[zio.aws.dynamodb.model.TimeToLiveStatus]
    def attributeName: Optional[TimeToLiveAttributeName]
    def getTimeToLiveStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TimeToLiveStatus] =
      AwsError.unwrapOptionField("timeToLiveStatus", timeToLiveStatus)
    def getAttributeName: ZIO[Any, AwsError, TimeToLiveAttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TimeToLiveDescription
  ) extends zio.aws.dynamodb.model.TimeToLiveDescription.ReadOnly {
    override val timeToLiveStatus
        : Optional[zio.aws.dynamodb.model.TimeToLiveStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeToLiveStatus())
        .map(value => zio.aws.dynamodb.model.TimeToLiveStatus.wrap(value))
    override val attributeName: Optional[TimeToLiveAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeName())
        .map(value =>
          zio.aws.dynamodb.model.primitives.TimeToLiveAttributeName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TimeToLiveDescription
  ): zio.aws.dynamodb.model.TimeToLiveDescription.ReadOnly = new Wrapper(impl)
}
