package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBackupResponse(
    backupDetails: Optional[zio.aws.dynamodb.model.BackupDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse = {
    import CreateBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse
      .builder()
      .optionallyWith(backupDetails.map(value => value.buildAwsValue()))(
        _.backupDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CreateBackupResponse.ReadOnly =
    zio.aws.dynamodb.model.CreateBackupResponse.wrap(buildAwsValue())
}
object CreateBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateBackupResponse =
      zio.aws.dynamodb.model
        .CreateBackupResponse(backupDetails.map(value => value.asEditable))
    def backupDetails: Optional[zio.aws.dynamodb.model.BackupDetails.ReadOnly]
    def getBackupDetails
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.BackupDetails.ReadOnly] =
      AwsError.unwrapOptionField("backupDetails", backupDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse
  ) extends zio.aws.dynamodb.model.CreateBackupResponse.ReadOnly {
    override val backupDetails
        : Optional[zio.aws.dynamodb.model.BackupDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupDetails())
        .map(value => zio.aws.dynamodb.model.BackupDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse
  ): zio.aws.dynamodb.model.CreateBackupResponse.ReadOnly = new Wrapper(impl)
}
