package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportTableResponse(
    importTableDescription: zio.aws.dynamodb.model.ImportTableDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ImportTableResponse = {
    import ImportTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ImportTableResponse
      .builder()
      .importTableDescription(importTableDescription.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ImportTableResponse.ReadOnly =
    zio.aws.dynamodb.model.ImportTableResponse.wrap(buildAwsValue())
}
object ImportTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ImportTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ImportTableResponse =
      zio.aws.dynamodb.model
        .ImportTableResponse(importTableDescription.asEditable)
    def importTableDescription
        : zio.aws.dynamodb.model.ImportTableDescription.ReadOnly
    def getImportTableDescription: ZIO[
      Any,
      Nothing,
      zio.aws.dynamodb.model.ImportTableDescription.ReadOnly
    ] = ZIO.succeed(importTableDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ImportTableResponse
  ) extends zio.aws.dynamodb.model.ImportTableResponse.ReadOnly {
    override val importTableDescription
        : zio.aws.dynamodb.model.ImportTableDescription.ReadOnly =
      zio.aws.dynamodb.model.ImportTableDescription
        .wrap(impl.importTableDescription())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ImportTableResponse
  ): zio.aws.dynamodb.model.ImportTableResponse.ReadOnly = new Wrapper(impl)
}
