package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TableCreationParameters(
    tableName: TableName,
    attributeDefinitions: Iterable[zio.aws.dynamodb.model.AttributeDefinition],
    keySchema: Iterable[zio.aws.dynamodb.model.KeySchemaElement],
    billingMode: Optional[zio.aws.dynamodb.model.BillingMode] = Optional.Absent,
    provisionedThroughput: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = Optional.Absent,
    sseSpecification: Optional[zio.aws.dynamodb.model.SSESpecification] =
      Optional.Absent,
    globalSecondaryIndexes: Optional[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndex]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TableCreationParameters = {
    import TableCreationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TableCreationParameters
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .attributeDefinitions(attributeDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .keySchema(keySchema.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(billingMode.map(value => value.unwrap))(_.billingMode)
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TableCreationParameters.ReadOnly =
    zio.aws.dynamodb.model.TableCreationParameters.wrap(buildAwsValue())
}
object TableCreationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TableCreationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TableCreationParameters =
      zio.aws.dynamodb.model.TableCreationParameters(
        tableName,
        attributeDefinitions.map { item =>
          item.asEditable
        },
        keySchema.map { item =>
          item.asEditable
        },
        billingMode.map(value => value),
        provisionedThroughput.map(value => value.asEditable),
        sseSpecification.map(value => value.asEditable),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tableName: TableName
    def attributeDefinitions
        : List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly]
    def keySchema: List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]
    def billingMode: Optional[zio.aws.dynamodb.model.BillingMode]
    def provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def sseSpecification
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly]
    def globalSecondaryIndexes
        : Optional[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getAttributeDefinitions: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.AttributeDefinition.ReadOnly
    ]] = ZIO.succeed(attributeDefinitions)
    def getKeySchema: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = ZIO.succeed(keySchema)
    def getBillingMode: ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] =
      AwsError.unwrapOptionField("billingMode", billingMode)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getSseSpecification
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      AwsError.unwrapOptionField("sseSpecification", sseSpecification)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TableCreationParameters
  ) extends zio.aws.dynamodb.model.TableCreationParameters.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val attributeDefinitions
        : List[zio.aws.dynamodb.model.AttributeDefinition.ReadOnly] = impl
      .attributeDefinitions()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.AttributeDefinition.wrap(item)
      }
      .toList
    override val keySchema
        : List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly] = impl
      .keySchema()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
      }
      .toList
    override val billingMode: Optional[zio.aws.dynamodb.model.BillingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingMode())
        .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val provisionedThroughput
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughput())
        .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
    override val sseSpecification
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseSpecification())
        .map(value => zio.aws.dynamodb.model.SSESpecification.wrap(value))
    override val globalSecondaryIndexes
        : Optional[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalSecondaryIndexes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.GlobalSecondaryIndex.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TableCreationParameters
  ): zio.aws.dynamodb.model.TableCreationParameters.ReadOnly = new Wrapper(impl)
}
