package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateTableReplicaAutoScalingRequest(
    globalSecondaryIndexUpdates: Optional[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate]
    ] = Optional.Absent,
    tableName: TableName,
    provisionedWriteCapacityAutoScalingUpdate: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = Optional.Absent,
    replicaUpdates: Optional[
      Iterable[zio.aws.dynamodb.model.ReplicaAutoScalingUpdate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest = {
    import UpdateTableReplicaAutoScalingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest
      .builder()
      .optionallyWith(
        globalSecondaryIndexUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexUpdates)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        provisionedWriteCapacityAutoScalingUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedWriteCapacityAutoScalingUpdate)
      .optionallyWith(
        replicaUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaUpdates)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingRequest
      .wrap(buildAwsValue())
}
object UpdateTableReplicaAutoScalingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingRequest =
      zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingRequest(
        globalSecondaryIndexUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tableName,
        provisionedWriteCapacityAutoScalingUpdate.map(value =>
          value.asEditable
        ),
        replicaUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalSecondaryIndexUpdates: Optional[List[
      zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate.ReadOnly
    ]]
    def tableName: TableName
    def provisionedWriteCapacityAutoScalingUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def replicaUpdates: Optional[
      List[zio.aws.dynamodb.model.ReplicaAutoScalingUpdate.ReadOnly]
    ]
    def getGlobalSecondaryIndexUpdates: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexUpdates",
      globalSecondaryIndexUpdates
    )
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getProvisionedWriteCapacityAutoScalingUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedWriteCapacityAutoScalingUpdate",
      provisionedWriteCapacityAutoScalingUpdate
    )
    def getReplicaUpdates: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaAutoScalingUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("replicaUpdates", replicaUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest
  ) extends zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingRequest.ReadOnly {
    override val globalSecondaryIndexUpdates: Optional[List[
      zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.globalSecondaryIndexUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate
            .wrap(item)
        }.toList
      )
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val provisionedWriteCapacityAutoScalingUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedWriteCapacityAutoScalingUpdate())
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
    override val replicaUpdates: Optional[
      List[zio.aws.dynamodb.model.ReplicaAutoScalingUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaAutoScalingUpdate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest
  ): zio.aws.dynamodb.model.UpdateTableReplicaAutoScalingRequest.ReadOnly =
    new Wrapper(impl)
}
