package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class DescribeTimeToLiveRequest(tableName: TableName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest = {
    import DescribeTimeToLiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeTimeToLiveRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeTimeToLiveRequest.wrap(buildAwsValue())
}
object DescribeTimeToLiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeTimeToLiveRequest =
      zio.aws.dynamodb.model.DescribeTimeToLiveRequest(tableName)
    def tableName: TableName
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest
  ) extends zio.aws.dynamodb.model.DescribeTimeToLiveRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest
  ): zio.aws.dynamodb.model.DescribeTimeToLiveRequest.ReadOnly = new Wrapper(
    impl
  )
}
