package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.BackupArn
import scala.jdk.CollectionConverters._
final case class DeleteBackupRequest(backupArn: BackupArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest = {
    import DeleteBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest
      .builder()
      .backupArn(BackupArn.unwrap(backupArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DeleteBackupRequest.ReadOnly =
    zio.aws.dynamodb.model.DeleteBackupRequest.wrap(buildAwsValue())
}
object DeleteBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteBackupRequest =
      zio.aws.dynamodb.model.DeleteBackupRequest(backupArn)
    def backupArn: BackupArn
    def getBackupArn: ZIO[Any, Nothing, BackupArn] = ZIO.succeed(backupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest
  ) extends zio.aws.dynamodb.model.DeleteBackupRequest.ReadOnly {
    override val backupArn: BackupArn =
      zio.aws.dynamodb.model.primitives.BackupArn(impl.backupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest
  ): zio.aws.dynamodb.model.DeleteBackupRequest.ReadOnly = new Wrapper(impl)
}
