package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransactGetItemsRequest(
    transactItems: Iterable[zio.aws.dynamodb.model.TransactGetItem],
    returnConsumedCapacity: Optional[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest = {
    import TransactGetItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest
      .builder()
      .transactItems(transactItems.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TransactGetItemsRequest.ReadOnly =
    zio.aws.dynamodb.model.TransactGetItemsRequest.wrap(buildAwsValue())
}
object TransactGetItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TransactGetItemsRequest =
      zio.aws.dynamodb.model.TransactGetItemsRequest(
        transactItems.map { item =>
          item.asEditable
        },
        returnConsumedCapacity.map(value => value)
      )
    def transactItems: List[zio.aws.dynamodb.model.TransactGetItem.ReadOnly]
    def returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def getTransactItems: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.TransactGetItem.ReadOnly
    ]] = ZIO.succeed(transactItems)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest
  ) extends zio.aws.dynamodb.model.TransactGetItemsRequest.ReadOnly {
    override val transactItems
        : List[zio.aws.dynamodb.model.TransactGetItem.ReadOnly] = impl
      .transactItems()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.TransactGetItem.wrap(item)
      }
      .toList
    override val returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnConsumedCapacity())
        .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest
  ): zio.aws.dynamodb.model.TransactGetItemsRequest.ReadOnly = new Wrapper(impl)
}
