package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  LastUpdateDateTime,
  ContributorInsightsRule,
  IndexName,
  TableName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeContributorInsightsResponse(
    tableName: Optional[TableName] = Optional.Absent,
    indexName: Optional[IndexName] = Optional.Absent,
    contributorInsightsRuleList: Optional[Iterable[ContributorInsightsRule]] =
      Optional.Absent,
    contributorInsightsStatus: Optional[
      zio.aws.dynamodb.model.ContributorInsightsStatus
    ] = Optional.Absent,
    lastUpdateDateTime: Optional[LastUpdateDateTime] = Optional.Absent,
    failureException: Optional[zio.aws.dynamodb.model.FailureException] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse = {
    import DescribeContributorInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        contributorInsightsRuleList.map(value =>
          value.map { item =>
            ContributorInsightsRule.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.contributorInsightsRuleList)
      .optionallyWith(contributorInsightsStatus.map(value => value.unwrap))(
        _.contributorInsightsStatus
      )
      .optionallyWith(
        lastUpdateDateTime.map(value =>
          LastUpdateDateTime.unwrap(value): Instant
        )
      )(_.lastUpdateDateTime)
      .optionallyWith(failureException.map(value => value.buildAwsValue()))(
        _.failureException
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeContributorInsightsResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeContributorInsightsResponse
      .wrap(buildAwsValue())
}
object DescribeContributorInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeContributorInsightsResponse =
      zio.aws.dynamodb.model.DescribeContributorInsightsResponse(
        tableName.map(value => value),
        indexName.map(value => value),
        contributorInsightsRuleList.map(value => value),
        contributorInsightsStatus.map(value => value),
        lastUpdateDateTime.map(value => value),
        failureException.map(value => value.asEditable)
      )
    def tableName: Optional[TableName]
    def indexName: Optional[IndexName]
    def contributorInsightsRuleList: Optional[List[ContributorInsightsRule]]
    def contributorInsightsStatus
        : Optional[zio.aws.dynamodb.model.ContributorInsightsStatus]
    def lastUpdateDateTime: Optional[LastUpdateDateTime]
    def failureException
        : Optional[zio.aws.dynamodb.model.FailureException.ReadOnly]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getContributorInsightsRuleList
        : ZIO[Any, AwsError, List[ContributorInsightsRule]] =
      AwsError.unwrapOptionField(
        "contributorInsightsRuleList",
        contributorInsightsRuleList
      )
    def getContributorInsightsStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ContributorInsightsStatus] =
      AwsError.unwrapOptionField(
        "contributorInsightsStatus",
        contributorInsightsStatus
      )
    def getLastUpdateDateTime: ZIO[Any, AwsError, LastUpdateDateTime] =
      AwsError.unwrapOptionField("lastUpdateDateTime", lastUpdateDateTime)
    def getFailureException
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.FailureException.ReadOnly] =
      AwsError.unwrapOptionField("failureException", failureException)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse
  ) extends zio.aws.dynamodb.model.DescribeContributorInsightsResponse.ReadOnly {
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val contributorInsightsRuleList
        : Optional[List[ContributorInsightsRule]] = zio.aws.core.internal
      .optionalFromNullable(impl.contributorInsightsRuleList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.ContributorInsightsRule(item)
        }.toList
      )
    override val contributorInsightsStatus
        : Optional[zio.aws.dynamodb.model.ContributorInsightsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contributorInsightsStatus())
        .map(value =>
          zio.aws.dynamodb.model.ContributorInsightsStatus.wrap(value)
        )
    override val lastUpdateDateTime: Optional[LastUpdateDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateDateTime())
        .map(value =>
          zio.aws.dynamodb.model.primitives.LastUpdateDateTime(value)
        )
    override val failureException
        : Optional[zio.aws.dynamodb.model.FailureException.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureException())
        .map(value => zio.aws.dynamodb.model.FailureException.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse
  ): zio.aws.dynamodb.model.DescribeContributorInsightsResponse.ReadOnly =
    new Wrapper(impl)
}
