package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicaUpdate(
    create: Optional[zio.aws.dynamodb.model.CreateReplicaAction] =
      Optional.Absent,
    delete: Optional[zio.aws.dynamodb.model.DeleteReplicaAction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate = {
    import ReplicaUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate
      .builder()
      .optionallyWith(create.map(value => value.buildAwsValue()))(_.create)
      .optionallyWith(delete.map(value => value.buildAwsValue()))(_.delete)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaUpdate.ReadOnly =
    zio.aws.dynamodb.model.ReplicaUpdate.wrap(buildAwsValue())
}
object ReplicaUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaUpdate =
      zio.aws.dynamodb.model.ReplicaUpdate(
        create.map(value => value.asEditable),
        delete.map(value => value.asEditable)
      )
    def create: Optional[zio.aws.dynamodb.model.CreateReplicaAction.ReadOnly]
    def delete: Optional[zio.aws.dynamodb.model.DeleteReplicaAction.ReadOnly]
    def getCreate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.CreateReplicaAction.ReadOnly
    ] = AwsError.unwrapOptionField("create", create)
    def getDelete: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.DeleteReplicaAction.ReadOnly
    ] = AwsError.unwrapOptionField("delete", delete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate
  ) extends zio.aws.dynamodb.model.ReplicaUpdate.ReadOnly {
    override val create
        : Optional[zio.aws.dynamodb.model.CreateReplicaAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.create())
        .map(value => zio.aws.dynamodb.model.CreateReplicaAction.wrap(value))
    override val delete
        : Optional[zio.aws.dynamodb.model.DeleteReplicaAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.delete())
        .map(value => zio.aws.dynamodb.model.DeleteReplicaAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate
  ): zio.aws.dynamodb.model.ReplicaUpdate.ReadOnly = new Wrapper(impl)
}
