package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchWriteItemRequest(
    requestItems: Map[TableName, Iterable[zio.aws.dynamodb.model.WriteRequest]],
    returnConsumedCapacity: Optional[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = Optional.Absent,
    returnItemCollectionMetrics: Optional[
      zio.aws.dynamodb.model.ReturnItemCollectionMetrics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest = {
    import BatchWriteItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest
      .builder()
      .requestItems(
        requestItems
          .map({ case (key, value) =>
            (TableName.unwrap(key): java.lang.String) -> value.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          })
          .asJava
      )
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .optionallyWith(returnItemCollectionMetrics.map(value => value.unwrap))(
        _.returnItemCollectionMetrics
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BatchWriteItemRequest.ReadOnly =
    zio.aws.dynamodb.model.BatchWriteItemRequest.wrap(buildAwsValue())
}
object BatchWriteItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchWriteItemRequest =
      zio.aws.dynamodb.model.BatchWriteItemRequest(
        requestItems.map({ case (key, value) =>
          key -> value.map { item =>
            item.asEditable
          }
        }),
        returnConsumedCapacity.map(value => value),
        returnItemCollectionMetrics.map(value => value)
      )
    def requestItems
        : Map[TableName, List[zio.aws.dynamodb.model.WriteRequest.ReadOnly]]
    def returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def returnItemCollectionMetrics
        : Optional[zio.aws.dynamodb.model.ReturnItemCollectionMetrics]
    def getRequestItems: ZIO[Any, Nothing, Map[TableName, List[
      zio.aws.dynamodb.model.WriteRequest.ReadOnly
    ]]] = ZIO.succeed(requestItems)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
    def getReturnItemCollectionMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ReturnItemCollectionMetrics
    ] = AwsError.unwrapOptionField(
      "returnItemCollectionMetrics",
      returnItemCollectionMetrics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest
  ) extends zio.aws.dynamodb.model.BatchWriteItemRequest.ReadOnly {
    override val requestItems
        : Map[TableName, List[zio.aws.dynamodb.model.WriteRequest.ReadOnly]] =
      impl
        .requestItems()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives
            .TableName(key) -> value.asScala.map { item =>
            zio.aws.dynamodb.model.WriteRequest.wrap(item)
          }.toList
        })
        .toMap
    override val returnConsumedCapacity
        : Optional[zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnConsumedCapacity())
        .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
    override val returnItemCollectionMetrics
        : Optional[zio.aws.dynamodb.model.ReturnItemCollectionMetrics] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnItemCollectionMetrics())
        .map(value =>
          zio.aws.dynamodb.model.ReturnItemCollectionMetrics.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest
  ): zio.aws.dynamodb.model.BatchWriteItemRequest.ReadOnly = new Wrapper(impl)
}
