package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class DescribeTableRequest(tableName: TableName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest = {
    import DescribeTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeTableRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeTableRequest.wrap(buildAwsValue())
}
object DescribeTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeTableRequest =
      zio.aws.dynamodb.model.DescribeTableRequest(tableName)
    def tableName: TableName
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest
  ) extends zio.aws.dynamodb.model.DescribeTableRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest
  ): zio.aws.dynamodb.model.DescribeTableRequest.ReadOnly = new Wrapper(impl)
}
