package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.RegionName
import scala.jdk.CollectionConverters._
final case class DeleteReplicationGroupMemberAction(regionName: RegionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteReplicationGroupMemberAction = {
    import DeleteReplicationGroupMemberAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteReplicationGroupMemberAction
      .builder()
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction.ReadOnly =
    zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction
      .wrap(buildAwsValue())
}
object DeleteReplicationGroupMemberAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteReplicationGroupMemberAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction =
      zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction(regionName)
    def regionName: RegionName
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteReplicationGroupMemberAction
  ) extends zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction.ReadOnly {
    override val regionName: RegionName =
      zio.aws.dynamodb.model.primitives.RegionName(impl.regionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteReplicationGroupMemberAction
  ): zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction.ReadOnly =
    new Wrapper(impl)
}
