package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{IndexName, TableName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateContributorInsightsResponse(
    tableName: Optional[TableName] = Optional.Absent,
    indexName: Optional[IndexName] = Optional.Absent,
    contributorInsightsStatus: Optional[
      zio.aws.dynamodb.model.ContributorInsightsStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse = {
    import UpdateContributorInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(contributorInsightsStatus.map(value => value.unwrap))(
        _.contributorInsightsStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateContributorInsightsResponse.ReadOnly =
    zio.aws.dynamodb.model.UpdateContributorInsightsResponse
      .wrap(buildAwsValue())
}
object UpdateContributorInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateContributorInsightsResponse =
      zio.aws.dynamodb.model.UpdateContributorInsightsResponse(
        tableName.map(value => value),
        indexName.map(value => value),
        contributorInsightsStatus.map(value => value)
      )
    def tableName: Optional[TableName]
    def indexName: Optional[IndexName]
    def contributorInsightsStatus
        : Optional[zio.aws.dynamodb.model.ContributorInsightsStatus]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getContributorInsightsStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ContributorInsightsStatus] =
      AwsError.unwrapOptionField(
        "contributorInsightsStatus",
        contributorInsightsStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse
  ) extends zio.aws.dynamodb.model.UpdateContributorInsightsResponse.ReadOnly {
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val contributorInsightsStatus
        : Optional[zio.aws.dynamodb.model.ContributorInsightsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contributorInsightsStatus())
        .map(value =>
          zio.aws.dynamodb.model.ContributorInsightsStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse
  ): zio.aws.dynamodb.model.UpdateContributorInsightsResponse.ReadOnly =
    new Wrapper(impl)
}
