package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.RegionName
import scala.jdk.CollectionConverters._
final case class CreateReplicaAction(regionName: RegionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateReplicaAction = {
    import CreateReplicaAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateReplicaAction
      .builder()
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CreateReplicaAction.ReadOnly =
    zio.aws.dynamodb.model.CreateReplicaAction.wrap(buildAwsValue())
}
object CreateReplicaAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateReplicaAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateReplicaAction =
      zio.aws.dynamodb.model.CreateReplicaAction(regionName)
    def regionName: RegionName
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateReplicaAction
  ) extends zio.aws.dynamodb.model.CreateReplicaAction.ReadOnly {
    override val regionName: RegionName =
      zio.aws.dynamodb.model.primitives.RegionName(impl.regionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateReplicaAction
  ): zio.aws.dynamodb.model.CreateReplicaAction.ReadOnly = new Wrapper(impl)
}
