package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class UpdateContinuousBackupsRequest(
    tableName: TableName,
    pointInTimeRecoverySpecification: zio.aws.dynamodb.model.PointInTimeRecoverySpecification
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest = {
    import UpdateContinuousBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .pointInTimeRecoverySpecification(
        pointInTimeRecoverySpecification.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateContinuousBackupsRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateContinuousBackupsRequest.wrap(buildAwsValue())
}
object UpdateContinuousBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateContinuousBackupsRequest =
      zio.aws.dynamodb.model.UpdateContinuousBackupsRequest(
        tableName,
        pointInTimeRecoverySpecification.asEditable
      )
    def tableName: TableName
    def pointInTimeRecoverySpecification
        : zio.aws.dynamodb.model.PointInTimeRecoverySpecification.ReadOnly
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getPointInTimeRecoverySpecification: ZIO[
      Any,
      Nothing,
      zio.aws.dynamodb.model.PointInTimeRecoverySpecification.ReadOnly
    ] = ZIO.succeed(pointInTimeRecoverySpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest
  ) extends zio.aws.dynamodb.model.UpdateContinuousBackupsRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val pointInTimeRecoverySpecification
        : zio.aws.dynamodb.model.PointInTimeRecoverySpecification.ReadOnly =
      zio.aws.dynamodb.model.PointInTimeRecoverySpecification
        .wrap(impl.pointInTimeRecoverySpecification())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest
  ): zio.aws.dynamodb.model.UpdateContinuousBackupsRequest.ReadOnly =
    new Wrapper(impl)
}
