package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  TableName,
  AttributeName,
  ConditionExpression,
  ExpressionAttributeNameVariable,
  ExpressionAttributeValueVariable
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Put(
    item: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue],
    tableName: TableName,
    conditionExpression: Optional[ConditionExpression] = Optional.Absent,
    expressionAttributeNames: Optional[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = Optional.Absent,
    expressionAttributeValues: Optional[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue
    ]] = Optional.Absent,
    returnValuesOnConditionCheckFailure: Optional[
      zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dynamodb.model.Put = {
    import Put.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Put
      .builder()
      .item(
        item
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        conditionExpression.map(value =>
          ConditionExpression.unwrap(value): java.lang.String
        )
      )(_.conditionExpression)
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable.unwrap(
                key
              ): java.lang.String) -> (AttributeName.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .optionallyWith(
        expressionAttributeValues.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeValueVariable
                .unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.expressionAttributeValues)
      .optionallyWith(
        returnValuesOnConditionCheckFailure.map(value => value.unwrap)
      )(_.returnValuesOnConditionCheckFailure)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.Put.ReadOnly =
    zio.aws.dynamodb.model.Put.wrap(buildAwsValue())
}
object Put {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Put] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.Put = zio.aws.dynamodb.model.Put(
      item.map({ case (key, value) =>
        key -> value.asEditable
      }),
      tableName,
      conditionExpression.map(value => value),
      expressionAttributeNames.map(value => value),
      expressionAttributeValues.map(value =>
        value.map({ case (key, value) =>
          key -> value.asEditable
        })
      ),
      returnValuesOnConditionCheckFailure.map(value => value)
    )
    def item: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def tableName: TableName
    def conditionExpression: Optional[ConditionExpression]
    def expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]]
    def expressionAttributeValues: Optional[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]]
    def returnValuesOnConditionCheckFailure
        : Optional[zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure]
    def getItem: ZIO[Any, Nothing, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = ZIO.succeed(item)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getConditionExpression: ZIO[Any, AwsError, ConditionExpression] =
      AwsError.unwrapOptionField("conditionExpression", conditionExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
    def getExpressionAttributeValues: ZIO[Any, AwsError, Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeValues",
      expressionAttributeValues
    )
    def getReturnValuesOnConditionCheckFailure: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure
    ] = AwsError.unwrapOptionField(
      "returnValuesOnConditionCheckFailure",
      returnValuesOnConditionCheckFailure
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Put
  ) extends zio.aws.dynamodb.model.Put.ReadOnly {
    override val item
        : Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      impl
        .item()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives.AttributeName(
            key
          ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
        })
        .toMap
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val conditionExpression: Optional[ConditionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionExpression())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ConditionExpression(value)
        )
    override val expressionAttributeNames
        : Optional[Map[ExpressionAttributeNameVariable, AttributeName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expressionAttributeNames())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
                key
              ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
            })
            .toMap
        )
    override val expressionAttributeValues: Optional[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.expressionAttributeValues())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeValueVariable(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val returnValuesOnConditionCheckFailure
        : Optional[zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnValuesOnConditionCheckFailure())
        .map(value =>
          zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Put
  ): zio.aws.dynamodb.model.Put.ReadOnly = new Wrapper(impl)
}
