package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait BackupStatus {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.BackupStatus
}
object BackupStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.BackupStatus
  ): zio.aws.dynamodb.model.BackupStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.BackupStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupStatus.AVAILABLE =>
      val r = AVAILABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.BackupStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupStatus =
      software.amazon.awssdk.services.dynamodb.model.BackupStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.dynamodb.model.BackupStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupStatus =
      software.amazon.awssdk.services.dynamodb.model.BackupStatus.CREATING
  }
  case object DELETED extends zio.aws.dynamodb.model.BackupStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupStatus =
      software.amazon.awssdk.services.dynamodb.model.BackupStatus.DELETED
  }
  case object AVAILABLE extends zio.aws.dynamodb.model.BackupStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupStatus =
      software.amazon.awssdk.services.dynamodb.model.BackupStatus.AVAILABLE
  }
}
