package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait BackupTypeFilter {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter
}
object BackupTypeFilter {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter
  ): zio.aws.dynamodb.model.BackupTypeFilter = value match {
    case software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.SYSTEM =>
      val r = SYSTEM
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.AWS_BACKUP =>
      val r = AWS_BACKUP
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.BackupTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter =
      software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.dynamodb.model.BackupTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter =
      software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.USER
  }
  case object SYSTEM extends zio.aws.dynamodb.model.BackupTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter =
      software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.SYSTEM
  }
  case object AWS_BACKUP extends zio.aws.dynamodb.model.BackupTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter =
      software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.AWS_BACKUP
  }
  case object ALL extends zio.aws.dynamodb.model.BackupTypeFilter {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter =
      software.amazon.awssdk.services.dynamodb.model.BackupTypeFilter.ALL
  }
}
