package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransactWriteItem(
    conditionCheck: Optional[zio.aws.dynamodb.model.ConditionCheck] =
      Optional.Absent,
    put: Optional[zio.aws.dynamodb.model.Put] = Optional.Absent,
    delete: Optional[zio.aws.dynamodb.model.Delete] = Optional.Absent,
    update: Optional[zio.aws.dynamodb.model.Update] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TransactWriteItem = {
    import TransactWriteItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TransactWriteItem
      .builder()
      .optionallyWith(conditionCheck.map(value => value.buildAwsValue()))(
        _.conditionCheck
      )
      .optionallyWith(put.map(value => value.buildAwsValue()))(_.put)
      .optionallyWith(delete.map(value => value.buildAwsValue()))(_.delete)
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TransactWriteItem.ReadOnly =
    zio.aws.dynamodb.model.TransactWriteItem.wrap(buildAwsValue())
}
object TransactWriteItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TransactWriteItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TransactWriteItem =
      zio.aws.dynamodb.model.TransactWriteItem(
        conditionCheck.map(value => value.asEditable),
        put.map(value => value.asEditable),
        delete.map(value => value.asEditable),
        update.map(value => value.asEditable)
      )
    def conditionCheck: Optional[zio.aws.dynamodb.model.ConditionCheck.ReadOnly]
    def put: Optional[zio.aws.dynamodb.model.Put.ReadOnly]
    def delete: Optional[zio.aws.dynamodb.model.Delete.ReadOnly]
    def update: Optional[zio.aws.dynamodb.model.Update.ReadOnly]
    def getConditionCheck
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConditionCheck.ReadOnly] =
      AwsError.unwrapOptionField("conditionCheck", conditionCheck)
    def getPut: ZIO[Any, AwsError, zio.aws.dynamodb.model.Put.ReadOnly] =
      AwsError.unwrapOptionField("put", put)
    def getDelete: ZIO[Any, AwsError, zio.aws.dynamodb.model.Delete.ReadOnly] =
      AwsError.unwrapOptionField("delete", delete)
    def getUpdate: ZIO[Any, AwsError, zio.aws.dynamodb.model.Update.ReadOnly] =
      AwsError.unwrapOptionField("update", update)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactWriteItem
  ) extends zio.aws.dynamodb.model.TransactWriteItem.ReadOnly {
    override val conditionCheck
        : Optional[zio.aws.dynamodb.model.ConditionCheck.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionCheck())
        .map(value => zio.aws.dynamodb.model.ConditionCheck.wrap(value))
    override val put: Optional[zio.aws.dynamodb.model.Put.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.put())
        .map(value => zio.aws.dynamodb.model.Put.wrap(value))
    override val delete: Optional[zio.aws.dynamodb.model.Delete.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.delete())
        .map(value => zio.aws.dynamodb.model.Delete.wrap(value))
    override val update: Optional[zio.aws.dynamodb.model.Update.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.update())
        .map(value => zio.aws.dynamodb.model.Update.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactWriteItem
  ): zio.aws.dynamodb.model.TransactWriteItem.ReadOnly = new Wrapper(impl)
}
