package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeEndpointsResponse(
    endpoints: Iterable[zio.aws.dynamodb.model.Endpoint]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse = {
    import DescribeEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse
      .builder()
      .endpoints(endpoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeEndpointsResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeEndpointsResponse.wrap(buildAwsValue())
}
object DescribeEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeEndpointsResponse =
      zio.aws.dynamodb.model.DescribeEndpointsResponse(endpoints.map { item =>
        item.asEditable
      })
    def endpoints: List[zio.aws.dynamodb.model.Endpoint.ReadOnly]
    def getEndpoints
        : ZIO[Any, Nothing, List[zio.aws.dynamodb.model.Endpoint.ReadOnly]] =
      ZIO.succeed(endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse
  ) extends zio.aws.dynamodb.model.DescribeEndpointsResponse.ReadOnly {
    override val endpoints: List[zio.aws.dynamodb.model.Endpoint.ReadOnly] =
      impl
        .endpoints()
        .asScala
        .map { item =>
          zio.aws.dynamodb.model.Endpoint.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse
  ): zio.aws.dynamodb.model.DescribeEndpointsResponse.ReadOnly = new Wrapper(
    impl
  )
}
