package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Capacity(
    readCapacityUnits: Optional[ConsumedCapacityUnits] = Optional.Absent,
    writeCapacityUnits: Optional[ConsumedCapacityUnits] = Optional.Absent,
    capacityUnits: Optional[ConsumedCapacityUnits] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.Capacity = {
    import Capacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Capacity
      .builder()
      .optionallyWith(
        readCapacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.readCapacityUnits)
      .optionallyWith(
        writeCapacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.writeCapacityUnits)
      .optionallyWith(
        capacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.capacityUnits)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.Capacity.ReadOnly =
    zio.aws.dynamodb.model.Capacity.wrap(buildAwsValue())
}
object Capacity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Capacity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.Capacity =
      zio.aws.dynamodb.model.Capacity(
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value),
        capacityUnits.map(value => value)
      )
    def readCapacityUnits: Optional[ConsumedCapacityUnits]
    def writeCapacityUnits: Optional[ConsumedCapacityUnits]
    def capacityUnits: Optional[ConsumedCapacityUnits]
    def getReadCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
    def getCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("capacityUnits", capacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Capacity
  ) extends zio.aws.dynamodb.model.Capacity.ReadOnly {
    override val readCapacityUnits: Optional[ConsumedCapacityUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
        )
    override val writeCapacityUnits: Optional[ConsumedCapacityUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
        )
    override val capacityUnits: Optional[ConsumedCapacityUnits] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Capacity
  ): zio.aws.dynamodb.model.Capacity.ReadOnly = new Wrapper(impl)
}
