package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait TableStatus {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.TableStatus
}
object TableStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.TableStatus
  ): zio.aws.dynamodb.model.TableStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.TableStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.TableStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.dynamodb.model.TableStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.dynamodb.model.TableStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.dynamodb.model.TableStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.dynamodb.model.TableStatus.INACCESSIBLE_ENCRYPTION_CREDENTIALS =>
      val r = INACCESSIBLE_ENCRYPTION_CREDENTIALS
      r
    case software.amazon.awssdk.services.dynamodb.model.TableStatus.ARCHIVING =>
      val r = ARCHIVING
      r
    case software.amazon.awssdk.services.dynamodb.model.TableStatus.ARCHIVED =>
      val r = ARCHIVED
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableStatus =
      software.amazon.awssdk.services.dynamodb.model.TableStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.dynamodb.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableStatus =
      software.amazon.awssdk.services.dynamodb.model.TableStatus.CREATING
  }
  case object UPDATING extends zio.aws.dynamodb.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableStatus =
      software.amazon.awssdk.services.dynamodb.model.TableStatus.UPDATING
  }
  case object DELETING extends zio.aws.dynamodb.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableStatus =
      software.amazon.awssdk.services.dynamodb.model.TableStatus.DELETING
  }
  case object ACTIVE extends zio.aws.dynamodb.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableStatus =
      software.amazon.awssdk.services.dynamodb.model.TableStatus.ACTIVE
  }
  case object INACCESSIBLE_ENCRYPTION_CREDENTIALS
      extends zio.aws.dynamodb.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableStatus =
      software.amazon.awssdk.services.dynamodb.model.TableStatus.INACCESSIBLE_ENCRYPTION_CREDENTIALS
  }
  case object ARCHIVING extends zio.aws.dynamodb.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableStatus =
      software.amazon.awssdk.services.dynamodb.model.TableStatus.ARCHIVING
  }
  case object ARCHIVED extends zio.aws.dynamodb.model.TableStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.TableStatus =
      software.amazon.awssdk.services.dynamodb.model.TableStatus.ARCHIVED
  }
}
