package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{Integer, AttributeName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QueryResponse(
    items: Optional[
      Iterable[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]]
    ] = Optional.Absent,
    count: Optional[Integer] = Optional.Absent,
    scannedCount: Optional[Integer] = Optional.Absent,
    lastEvaluatedKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
    ] = Optional.Absent,
    consumedCapacity: Optional[zio.aws.dynamodb.model.ConsumedCapacity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.QueryResponse = {
    import QueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.QueryResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (AttributeName.unwrap(key): java.lang.String) -> value
                  .buildAwsValue()
              })
              .asJava
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(scannedCount.map(value => value: java.lang.Integer))(
        _.scannedCount
      )
      .optionallyWith(
        lastEvaluatedKey.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.lastEvaluatedKey)
      .optionallyWith(consumedCapacity.map(value => value.buildAwsValue()))(
        _.consumedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.QueryResponse.ReadOnly =
    zio.aws.dynamodb.model.QueryResponse.wrap(buildAwsValue())
}
object QueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.QueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.QueryResponse =
      zio.aws.dynamodb.model.QueryResponse(
        items.map(value =>
          value.map { item =>
            item.map({ case (key, value) =>
              key -> value.asEditable
            })
          }
        ),
        count.map(value => value),
        scannedCount.map(value => value),
        lastEvaluatedKey.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        consumedCapacity.map(value => value.asEditable)
      )
    def items: Optional[
      List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    ]
    def count: Optional[Integer]
    def scannedCount: Optional[Integer]
    def lastEvaluatedKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def consumedCapacity
        : Optional[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]
    def getItems: ZIO[Any, AwsError, List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]] = AwsError.unwrapOptionField("items", items)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getScannedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scannedCount", scannedCount)
    def getLastEvaluatedKey: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("lastEvaluatedKey", lastEvaluatedKey)
    def getConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] =
      AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.QueryResponse
  ) extends zio.aws.dynamodb.model.QueryResponse.ReadOnly {
    override val items: Optional[
      List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives.AttributeName(
                key
              ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
            })
            .toMap
        }.toList
      )
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
    override val scannedCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.scannedCount())
      .map(value => value: Integer)
    override val lastEvaluatedKey: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lastEvaluatedKey())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val consumedCapacity
        : Optional[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedCapacity())
        .map(value => zio.aws.dynamodb.model.ConsumedCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.QueryResponse
  ): zio.aws.dynamodb.model.QueryResponse.ReadOnly = new Wrapper(impl)
}
