package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PositiveLongObject, TableName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateGlobalTableSettingsRequest(
    globalTableName: TableName,
    globalTableBillingMode: Optional[zio.aws.dynamodb.model.BillingMode] =
      Optional.Absent,
    globalTableProvisionedWriteCapacityUnits: Optional[PositiveLongObject] =
      Optional.Absent,
    globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = Optional.Absent,
    globalTableGlobalSecondaryIndexSettingsUpdate: Optional[Iterable[
      zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate
    ]] = Optional.Absent,
    replicaSettingsUpdate: Optional[
      Iterable[zio.aws.dynamodb.model.ReplicaSettingsUpdate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest = {
    import UpdateGlobalTableSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest
      .builder()
      .globalTableName(TableName.unwrap(globalTableName): java.lang.String)
      .optionallyWith(globalTableBillingMode.map(value => value.unwrap))(
        _.globalTableBillingMode
      )
      .optionallyWith(
        globalTableProvisionedWriteCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.globalTableProvisionedWriteCapacityUnits)
      .optionallyWith(
        globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate.map(
          value => value.buildAwsValue()
        )
      )(_.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate)
      .optionallyWith(
        globalTableGlobalSecondaryIndexSettingsUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalTableGlobalSecondaryIndexSettingsUpdate)
      .optionallyWith(
        replicaSettingsUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaSettingsUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateGlobalTableSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest =
      zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest(
        globalTableName,
        globalTableBillingMode.map(value => value),
        globalTableProvisionedWriteCapacityUnits.map(value => value),
        globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate.map(
          value => value.asEditable
        ),
        globalTableGlobalSecondaryIndexSettingsUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicaSettingsUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalTableName: TableName
    def globalTableBillingMode: Optional[zio.aws.dynamodb.model.BillingMode]
    def globalTableProvisionedWriteCapacityUnits: Optional[PositiveLongObject]
    def globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def globalTableGlobalSecondaryIndexSettingsUpdate: Optional[List[
      zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate.ReadOnly
    ]]
    def replicaSettingsUpdate
        : Optional[List[zio.aws.dynamodb.model.ReplicaSettingsUpdate.ReadOnly]]
    def getGlobalTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(globalTableName)
    def getGlobalTableBillingMode
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] = AwsError
      .unwrapOptionField("globalTableBillingMode", globalTableBillingMode)
    def getGlobalTableProvisionedWriteCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "globalTableProvisionedWriteCapacityUnits",
      globalTableProvisionedWriteCapacityUnits
    )
    def getGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate",
      globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
    )
    def getGlobalTableGlobalSecondaryIndexSettingsUpdate
        : ZIO[Any, AwsError, List[
          zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "globalTableGlobalSecondaryIndexSettingsUpdate",
      globalTableGlobalSecondaryIndexSettingsUpdate
    )
    def getReplicaSettingsUpdate: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaSettingsUpdate.ReadOnly
    ]] =
      AwsError.unwrapOptionField("replicaSettingsUpdate", replicaSettingsUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest
  ) extends zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest.ReadOnly {
    override val globalTableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.globalTableName())
    override val globalTableBillingMode
        : Optional[zio.aws.dynamodb.model.BillingMode] = zio.aws.core.internal
      .optionalFromNullable(impl.globalTableBillingMode())
      .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val globalTableProvisionedWriteCapacityUnits
        : Optional[PositiveLongObject] = zio.aws.core.internal
      .optionalFromNullable(impl.globalTableProvisionedWriteCapacityUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(
          impl.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate()
        )
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
    override val globalTableGlobalSecondaryIndexSettingsUpdate: Optional[List[
      zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(
        impl.globalTableGlobalSecondaryIndexSettingsUpdate()
      )
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate
            .wrap(item)
        }.toList
      )
    override val replicaSettingsUpdate: Optional[
      List[zio.aws.dynamodb.model.ReplicaSettingsUpdate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaSettingsUpdate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaSettingsUpdate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest
  ): zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
