package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TableAutoScalingDescription(
    tableName: Optional[TableName] = Optional.Absent,
    tableStatus: Optional[zio.aws.dynamodb.model.TableStatus] = Optional.Absent,
    replicas: Optional[
      Iterable[zio.aws.dynamodb.model.ReplicaAutoScalingDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription = {
    import TableAutoScalingDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(tableStatus.map(value => value.unwrap))(_.tableStatus)
      .optionallyWith(
        replicas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicas)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly =
    zio.aws.dynamodb.model.TableAutoScalingDescription.wrap(buildAwsValue())
}
object TableAutoScalingDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TableAutoScalingDescription =
      zio.aws.dynamodb.model.TableAutoScalingDescription(
        tableName.map(value => value),
        tableStatus.map(value => value),
        replicas.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tableName: Optional[TableName]
    def tableStatus: Optional[zio.aws.dynamodb.model.TableStatus]
    def replicas: Optional[
      List[zio.aws.dynamodb.model.ReplicaAutoScalingDescription.ReadOnly]
    ]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getTableStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableStatus] =
      AwsError.unwrapOptionField("tableStatus", tableStatus)
    def getReplicas: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaAutoScalingDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("replicas", replicas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription
  ) extends zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly {
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val tableStatus: Optional[zio.aws.dynamodb.model.TableStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableStatus())
        .map(value => zio.aws.dynamodb.model.TableStatus.wrap(value))
    override val replicas: Optional[
      List[zio.aws.dynamodb.model.ReplicaAutoScalingDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicas())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaAutoScalingDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription
  ): zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly = new Wrapper(
    impl
  )
}
