package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters._
final case class DeleteGlobalSecondaryIndexAction(indexName: IndexName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction = {
    import DeleteGlobalSecondaryIndexAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.ReadOnly =
    zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction
      .wrap(buildAwsValue())
}
object DeleteGlobalSecondaryIndexAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction =
      zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction(indexName)
    def indexName: IndexName
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction
  ) extends zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteGlobalSecondaryIndexAction
  ): zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.ReadOnly =
    new Wrapper(impl)
}
