package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LocalSecondaryIndexInfo(
    indexName: Optional[IndexName] = Optional.Absent,
    keySchema: Optional[Iterable[zio.aws.dynamodb.model.KeySchemaElement]] =
      Optional.Absent,
    projection: Optional[zio.aws.dynamodb.model.Projection] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexInfo = {
    import LocalSecondaryIndexInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexInfo
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(projection.map(value => value.buildAwsValue()))(
        _.projection
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.LocalSecondaryIndexInfo.ReadOnly =
    zio.aws.dynamodb.model.LocalSecondaryIndexInfo.wrap(buildAwsValue())
}
object LocalSecondaryIndexInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.LocalSecondaryIndexInfo =
      zio.aws.dynamodb.model.LocalSecondaryIndexInfo(
        indexName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projection.map(value => value.asEditable)
      )
    def indexName: Optional[IndexName]
    def keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]]
    def projection: Optional[zio.aws.dynamodb.model.Projection.ReadOnly]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getProjection
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.Projection.ReadOnly] =
      AwsError.unwrapOptionField("projection", projection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexInfo
  ) extends zio.aws.dynamodb.model.LocalSecondaryIndexInfo.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val keySchema
        : Optional[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySchema())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
          }.toList
        )
    override val projection
        : Optional[zio.aws.dynamodb.model.Projection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projection())
        .map(value => zio.aws.dynamodb.model.Projection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexInfo
  ): zio.aws.dynamodb.model.LocalSecondaryIndexInfo.ReadOnly = new Wrapper(impl)
}
