package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PositiveLongObject, IndexName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicaGlobalSecondaryIndexSettingsDescription(
    indexName: IndexName,
    indexStatus: Optional[zio.aws.dynamodb.model.IndexStatus] = Optional.Absent,
    provisionedReadCapacityUnits: Optional[PositiveLongObject] =
      Optional.Absent,
    provisionedReadCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = Optional.Absent,
    provisionedWriteCapacityUnits: Optional[PositiveLongObject] =
      Optional.Absent,
    provisionedWriteCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription = {
    import ReplicaGlobalSecondaryIndexSettingsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .optionallyWith(indexStatus.map(value => value.unwrap))(_.indexStatus)
      .optionallyWith(
        provisionedReadCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.provisionedReadCapacityUnits)
      .optionallyWith(
        provisionedReadCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedReadCapacityAutoScalingSettings)
      .optionallyWith(
        provisionedWriteCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.provisionedWriteCapacityUnits)
      .optionallyWith(
        provisionedWriteCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedWriteCapacityAutoScalingSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
      .wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndexSettingsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription(
        indexName,
        indexStatus.map(value => value),
        provisionedReadCapacityUnits.map(value => value),
        provisionedReadCapacityAutoScalingSettings.map(value =>
          value.asEditable
        ),
        provisionedWriteCapacityUnits.map(value => value),
        provisionedWriteCapacityAutoScalingSettings.map(value =>
          value.asEditable
        )
      )
    def indexName: IndexName
    def indexStatus: Optional[zio.aws.dynamodb.model.IndexStatus]
    def provisionedReadCapacityUnits: Optional[PositiveLongObject]
    def provisionedReadCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ]
    def provisionedWriteCapacityUnits: Optional[PositiveLongObject]
    def provisionedWriteCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ]
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
    def getIndexStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.IndexStatus] =
      AwsError.unwrapOptionField("indexStatus", indexStatus)
    def getProvisionedReadCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "provisionedReadCapacityUnits",
      provisionedReadCapacityUnits
    )
    def getProvisionedReadCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedReadCapacityAutoScalingSettings",
      provisionedReadCapacityAutoScalingSettings
    )
    def getProvisionedWriteCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "provisionedWriteCapacityUnits",
      provisionedWriteCapacityUnits
    )
    def getProvisionedWriteCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedWriteCapacityAutoScalingSettings",
      provisionedWriteCapacityAutoScalingSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly {
    override val indexName: IndexName =
      zio.aws.dynamodb.model.primitives.IndexName(impl.indexName())
    override val indexStatus: Optional[zio.aws.dynamodb.model.IndexStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexStatus())
        .map(value => zio.aws.dynamodb.model.IndexStatus.wrap(value))
    override val provisionedReadCapacityUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedReadCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val provisionedReadCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedReadCapacityAutoScalingSettings())
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
    override val provisionedWriteCapacityUnits: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedWriteCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val provisionedWriteCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedWriteCapacityAutoScalingSettings())
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly =
    new Wrapper(impl)
}
